/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemUtils {
    private static final ItemStack REFERENCE = new ItemStack((ItemLike)Items.f_41852_);

    @Nullable
    public static ItemEntity dropItemOnEntity(LivingEntity entity, ItemStack stack) {
        double z;
        double y;
        if (stack.m_41619_()) {
            return null;
        }
        double x = entity.m_20185_();
        ItemEntity entityItem = new ItemEntity(entity.f_19853_, x, y = entity.m_20186_(), z = entity.m_20189_(), stack.m_41777_());
        return entity.f_19853_.m_7967_((Entity)entityItem) ? entityItem : null;
    }

    public static boolean areStacksEqualIgnoringSize(ItemStack a, ItemStack b) {
        if (a.m_41619_()) {
            return b.m_41619_();
        }
        if (b.m_41619_()) {
            return false;
        }
        if (!a.m_41656_(b)) {
            return false;
        }
        return ItemStack.m_41658_((ItemStack)a, (ItemStack)b);
    }

    public static ItemStack insertStack(Container inv, ItemStack stack) {
        return ItemUtils.insertStackAdv((Container)inv, (ItemStack)stack).remainder;
    }

    public static InsertStackResult insertStackAdv(Container inv, ItemStack stack) {
        if (stack.m_41619_()) {
            return new InsertStackResult(stack, new int[0]);
        }
        int stackSizeLimit = Math.min(stack.m_41741_(), inv.m_6893_());
        int size = inv.m_6643_();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        ItemStack remainder = stack;
        for (int slot = 0; slot < size && !remainder.m_41619_(); ++slot) {
            int toTransfer;
            ItemStack current;
            if (!inv.m_7013_(slot, stack) || !(current = inv.m_8020_(slot)).m_41619_() && !ItemUtils.areStacksEqualIgnoringSize(current, remainder) || (toTransfer = Math.min(current.m_41613_() + remainder.m_41613_(), stackSizeLimit) - current.m_41613_()) <= 0) continue;
            if (current.m_41619_()) {
                current = remainder.m_41777_();
                current.m_41764_(toTransfer);
            } else {
                current.m_41764_(current.m_41613_() + toTransfer);
            }
            if (remainder == stack) {
                remainder = stack.m_41777_();
            }
            remainder.m_41764_(remainder.m_41613_() - toTransfer);
            inv.m_6836_(slot, current);
            slots.add(slot);
        }
        int[] slotsArray = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            slotsArray[i] = (Integer)slots.get(i);
        }
        return new InsertStackResult(remainder, slotsArray);
    }

    public static int getMaxStackSize() {
        return REFERENCE.m_41741_();
    }

    @Nullable
    public static ResourceLocation getIdentifier(ItemStack stack) {
        return stack.m_41720_().getRegistryName();
    }

    public static class InsertStackResult {
        public final ItemStack remainder;
        public final int[] slots;

        public InsertStackResult(ItemStack remainder, int[] slots) {
            this.remainder = remainder;
            this.slots = slots;
        }
    }
}

